/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.graphics.Canvas3D;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.RelativePosition;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;

class TextPlateDrawable
implements Drawable,
Serializable {
    String title_;
    RelativePosition position_;
    Color titleColor_;
    Color titleBackgroundColor_;
    Font titleFont_;
    int pad_;
    boolean transparent_;
    int borderWidth_;

    public TextPlateDrawable(String title, RelativePosition position, Color titleColor, Font titleFont, Color titleBackgroundColor, int pad, boolean transparent, int borderWidth) {
        this.title_ = title;
        this.position_ = position;
        this.titleColor_ = titleColor;
        this.titleBackgroundColor_ = titleBackgroundColor;
        this.titleFont_ = titleFont;
        this.pad_ = pad;
        this.transparent_ = transparent;
        this.borderWidth_ = borderWidth;
    }

    public void drawOn(Canvas3D canvas, Graphics g) {
        Dimension size = canvas.getSize();
        g.setFont(this.titleFont_);
        FontMetrics metrics = g.getFontMetrics();
        int stringWidth = metrics.stringWidth(this.title_);
        int plateWidth = stringWidth + 2 * this.pad_;
        int plateHeight = metrics.getHeight() + this.pad_;
        int x = this.position_.left(size.width, plateWidth);
        int y = this.position_.top(size.height, plateHeight);
        if (!this.transparent_) {
            g.setColor(this.titleBackgroundColor_);
            g.fillRect(x, y, plateWidth, plateHeight);
        }
        g.setColor(this.titleColor_);
        g.drawString(this.title_, x + this.pad_, y + (int)((double)(plateHeight + metrics.getHeight()) / 2.0 + 0.5) - metrics.getMaxDescent());
        g.setColor(this.titleBackgroundColor_);
        for (int i = 0; i < this.borderWidth_; ++i) {
            g.draw3DRect(x + i, y + i, plateWidth - 2 * i, plateHeight - 2 * i, true);
        }
    }
}

